/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.StringArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class StringArrayEncoding
implements Encoding<ByteArray> {
    private static final String kind = "StringArray";
    private Deque<Encoding<?>> dataEncoding;
    private String stringData;
    private Deque<Encoding<?>> offsetEncoding;
    private byte[] offsets;

    public StringArrayEncoding() {
    }

    public StringArrayEncoding(String stringData, byte[] offsets, Deque<Encoding<?>> outputEncoding, Deque<Encoding<?>> offsetEncoding) {
        this.dataEncoding = outputEncoding;
        this.stringData = stringData;
        this.offsetEncoding = offsetEncoding;
        this.offsets = offsets;
    }

    public StringArrayEncoding(Map<String, Object> encoding, Deque<Encoding<?>> outputEncoding, Deque<Encoding<?>> offsetEncoding) {
        this((String)encoding.get("stringData"), (byte[])encoding.get("offsets"), outputEncoding, offsetEncoding);
    }

    public Deque<Encoding<?>> getDataEncoding() {
        return this.dataEncoding;
    }

    public String getStringData() {
        return this.stringData;
    }

    public Deque<Encoding<?>> getOffsetEncoding() {
        return this.offsetEncoding;
    }

    public byte[] getOffsets() {
        return this.offsets;
    }

    public void setDataEncoding(Deque<Encoding<?>> dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setStringData(String stringData) {
        this.stringData = stringData;
    }

    public void setOffsetEncoding(Deque<Encoding<?>> offsetEncoding) {
        this.offsetEncoding = offsetEncoding;
    }

    public void setOffsets(byte[] offsets) {
        this.offsets = offsets;
    }

    @Override
    public String getKind() {
        return kind;
    }

    public StringArray decode(ByteArray current) {
        return Codec.STRING_ARRAY_CODEC.decode(current, this);
    }

    public String toString() {
        return "StringArrayEncoding{dataEncoding=" + this.dataEncoding + ", stringData='" + this.stringData + '\'' + ", offsetEncoding=" + this.offsetEncoding + ", offsets=" + Arrays.toString(this.offsets) + '}';
    }
}

