/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.Map;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.encoding.Encoding;

public class IntervalQuantizationEncoding
implements Encoding<Int32Array> {
    private static final String kind = "IntervalQuantization";
    private final int min;
    private final int max;
    private final int numSteps;
    private int srcType;

    public IntervalQuantizationEncoding(int min, int max, int numSteps) {
        this(min, max, numSteps, 0);
    }

    public IntervalQuantizationEncoding(int min, int max, int numSteps, int srcType) {
        this.min = min;
        this.max = max;
        this.numSteps = numSteps;
        this.srcType = srcType;
    }

    public IntervalQuantizationEncoding(Map<String, Object> encoding) {
        this((Integer)encoding.get("min"), (Integer)encoding.get("max"), (Integer)encoding.get("numSteps"), (Integer)encoding.get("srcType"));
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public int getSrcType() {
        return this.srcType;
    }

    public void setSrcType(int srcType) {
        this.srcType = srcType;
    }

    @Override
    public String getKind() {
        return kind;
    }

    public FloatArray decode(Int32Array current) {
        return Codec.INTERVAL_QUANTIZATION_CODEC.decode(current, this);
    }

    public String toString() {
        return "IntervalQuantizationEncoding{min=" + this.min + ", max=" + this.max + ", numSteps=" + this.numSteps + ", srcType=" + this.srcType + '}';
    }
}

