/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.Map;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class IntegerPackingEncoding
implements Encoding<IntArray> {
    private static final String kind = "IntegerPacking";
    private int byteCount;
    private boolean isUnsigned;
    private int srcSize;

    public IntegerPackingEncoding() {
    }

    public IntegerPackingEncoding(int byteCount, boolean isUnsigned, int srcSize) {
        this.byteCount = byteCount;
        this.isUnsigned = isUnsigned;
        this.srcSize = srcSize;
    }

    public IntegerPackingEncoding(Map<String, Object> encoding) {
        this((Integer)encoding.get("byteCount"), (Boolean)encoding.get("isUnsigned"), (Integer)encoding.get("srcSize"));
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public int getSrcSize() {
        return this.srcSize;
    }

    public void setByteCount(int byteCount) {
        this.byteCount = byteCount;
    }

    public void setUnsigned(boolean unsigned) {
        this.isUnsigned = unsigned;
    }

    public void setSrcSize(int srcSize) {
        this.srcSize = srcSize;
    }

    @Override
    public String getKind() {
        return kind;
    }

    public Int32Array decode(IntArray current) {
        return Codec.INTEGER_PACKING_CODEC.decode(current, this);
    }

    public String toString() {
        return "IntegerPackingEncoding{byteCount=" + this.byteCount + ", isUnsigned=" + this.isUnsigned + ", srcSize=" + this.srcSize + '}';
    }
}

