/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.Map;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.encoding.Encoding;

public class FixedPointEncoding
implements Encoding<Int32Array> {
    private static final String kind = "FixedPoint";
    private final int factor;
    private int srcType;

    public FixedPointEncoding(int factor) {
        this.factor = factor;
    }

    public FixedPointEncoding(int factor, int srcType) {
        this.factor = factor;
        this.srcType = srcType;
    }

    public FixedPointEncoding(Map<String, Object> encoding) {
        this((Integer)encoding.get("factor"), (Integer)encoding.get("srcType"));
    }

    public int getFactor() {
        return this.factor;
    }

    public int getSrcType() {
        return this.srcType;
    }

    public void setSrcType(int srcType) {
        this.srcType = srcType;
    }

    @Override
    public String getKind() {
        return kind;
    }

    public FloatArray decode(Int32Array current) {
        return Codec.FIXED_POINT_CODEC.decode(current, this);
    }

    public String toString() {
        return "FixedPointEncoding{factor=" + this.factor + ", srcType=" + this.srcType + '}';
    }
}

