/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.Map;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.SignedIntArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class DeltaEncoding
implements Encoding<SignedIntArray> {
    private static final String kind = "Delta";
    private int origin;
    private int srcType;

    public DeltaEncoding() {
    }

    public DeltaEncoding(int origin, int srcType) {
        this.origin = origin;
        this.srcType = srcType;
    }

    public DeltaEncoding(Map<String, Object> encoding) {
        this((Integer)encoding.get("origin"), (Integer)encoding.get("srcType"));
    }

    public int getOrigin() {
        return this.origin;
    }

    public int getSrcType() {
        return this.srcType;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public void setSrcType(int srcType) {
        this.srcType = srcType;
    }

    @Override
    public String getKind() {
        return kind;
    }

    public SignedIntArray decode(SignedIntArray current) {
        return Codec.DELTA_CODEC.decode(current, this);
    }

    public String toString() {
        return "DeltaEncoding{origin=" + this.origin + ", srcType=" + this.srcType + '}';
    }
}

