/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.UnsignedIntArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class Uint32Array
extends AbstractEncodedData<int[]>
implements UnsignedIntArray {
    private static final int NUMBER_OF_BYTES = 4;
    static final int TYPE = 6;

    Uint32Array(int[] data) {
        this(data, (Deque<Encoding<?>>)new ArrayDeque());
    }

    Uint32Array(int[] data, Deque<Encoding<?>> encoding) {
        super(data, encoding);
    }

    @Override
    public int[] getData() {
        return (int[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        return Int32Array.int32ToByteArray(this.getData());
    }

    @Override
    public int getNumberOfBytes() {
        return 4;
    }

    @Override
    public int getType() {
        return 6;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }
}

