/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.SignedIntArray;
import org.rcsb.cif.binary.encoding.DeltaEncoding;
import org.rcsb.cif.binary.encoding.Encoding;

public class Int8Array
extends AbstractEncodedData<int[]>
implements SignedIntArray {
    private static final int NUMBER_OF_BYTES = 1;
    static final int TYPE = 1;

    Int8Array(int[] data) {
        this(data, (Deque<Encoding<?>>)new ArrayDeque());
    }

    Int8Array(int[] data, Deque<Encoding<?>> encoding) {
        super(data, encoding);
    }

    @Override
    public int[] getData() {
        return (int[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        return Int8Array.int8ToByteArray(this.getData());
    }

    static byte[] int8ToByteArray(int[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length);
        for (int i : data) {
            buffer.put((byte)i);
        }
        return buffer.array();
    }

    @Override
    public int getNumberOfBytes() {
        return 1;
    }

    @Override
    public int getType() {
        return 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }

    @Override
    public Int8Array encode(DeltaEncoding encoding) {
        return Codec.DELTA_CODEC.encode(this, encoding);
    }

    @Override
    public Int8Array decode(DeltaEncoding encoding) {
        return Codec.DELTA_CODEC.decode(this, encoding);
    }
}

