/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.codec.Classifier;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.data.SignedIntArray;
import org.rcsb.cif.binary.encoding.DeltaEncoding;
import org.rcsb.cif.binary.encoding.Encoding;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;
import org.rcsb.cif.binary.encoding.IntegerPackingEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;

public class Int32Array
extends AbstractEncodedData<int[]>
implements SignedIntArray {
    private static final int NUMBER_OF_BYTES = 4;
    static final int TYPE = 3;

    Int32Array(int[] data) {
        this(data, (Deque<Encoding<?>>)new ArrayDeque());
    }

    Int32Array(int[] data, Deque<Encoding<?>> encoding) {
        super(data, encoding);
    }

    @Override
    public int[] getData() {
        return (int[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        return Int32Array.int32ToByteArray(this.getData());
    }

    static byte[] int32ToByteArray(int[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i : data) {
            buffer.putInt(i);
        }
        return buffer.array();
    }

    @Override
    public int getNumberOfBytes() {
        return 4;
    }

    @Override
    public int getType() {
        return 3;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }

    public IntArray encode(IntegerPackingEncoding encoding) {
        return Codec.INTEGER_PACKING_CODEC.encode(this, encoding);
    }

    @Override
    public Int32Array encode(DeltaEncoding encoding) {
        return Codec.DELTA_CODEC.encode(this, encoding);
    }

    @Override
    public Int32Array decode(DeltaEncoding encoding) {
        return Codec.DELTA_CODEC.decode(this, encoding);
    }

    public FloatArray decode(FixedPointEncoding encoding) {
        return Codec.FIXED_POINT_CODEC.decode(this, encoding);
    }

    public IntArray decode(RunLengthEncoding encoding) {
        return Codec.RUN_LENGTH_CODEC.decode(this, encoding);
    }

    public EncodingStrategyHint classify() {
        return Classifier.classify(this);
    }
}

