/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.codec.Classifier;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class Float64Array
extends AbstractEncodedData<double[]>
implements FloatArray {
    private static final int NUMBER_OF_BYTES = 8;
    private static final int TYPE = 33;

    Float64Array(double[] data) {
        this(data, (Deque<Encoding<?>>)new ArrayDeque());
    }

    Float64Array(double[] data, Deque<Encoding<?>> encoding) {
        super(data, encoding);
    }

    @Override
    public double[] getData() {
        return (double[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(this.length() * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (double d : this.getData()) {
            buffer.putDouble(d);
        }
        return buffer.array();
    }

    @Override
    public int getNumberOfBytes() {
        return 8;
    }

    @Override
    public int getType() {
        return 33;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }

    public EncodingStrategyHint classify() {
        return Classifier.classify(this);
    }
}

