/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class Float32Array
extends AbstractEncodedData<double[]>
implements FloatArray {
    private static final int NUMBER_OF_BYTES = 4;
    private static final int TYPE = 32;

    Float32Array(double[] data) {
        this(data, (Deque<Encoding<?>>)new ArrayDeque());
    }

    Float32Array(double[] data, Deque<Encoding<?>> encoding) {
        super(data, encoding);
    }

    @Override
    public double[] getData() {
        return (double[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(this.length() * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (double d : this.getData()) {
            buffer.putFloat((float)d);
        }
        return buffer.array();
    }

    @Override
    public int getNumberOfBytes() {
        return 4;
    }

    @Override
    public int getType() {
        return 32;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }
}

