/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.util.ArrayDeque;
import java.util.Deque;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Float32Array;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int16Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.Int8Array;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.data.StringArray;
import org.rcsb.cif.binary.data.Uint16Array;
import org.rcsb.cif.binary.data.Uint32Array;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.Encoding;

public class EncodedDataFactory {
    public static ByteArray byteArray(byte[] bytes) {
        return new ByteArray(bytes);
    }

    public static Float32Array float32Array(double[] floats) {
        return new Float32Array(floats);
    }

    public static Float64Array float64Array(double[] floats) {
        return new Float64Array(floats);
    }

    public static Int8Array int8Array(int[] ints) {
        return new Int8Array(ints);
    }

    public static Int16Array int16Array(int[] ints) {
        return new Int16Array(ints);
    }

    public static Int32Array int32Array(int[] ints) {
        return new Int32Array(ints);
    }

    public static Uint8Array uint8Array(int[] ints) {
        return new Uint8Array(ints);
    }

    public static Uint16Array uint16Array(int[] ints) {
        return new Uint16Array(ints);
    }

    public static Uint32Array uint32Array(int[] ints) {
        return new Uint32Array(ints);
    }

    public static StringArray stringArray(String[] strings) {
        return new StringArray(strings);
    }

    public static ByteArray byteArray(byte[] bytes, Deque<Encoding<?>> encoding) {
        return new ByteArray(bytes, encoding);
    }

    public static Float32Array float32Array(double[] floats, Deque<Encoding<?>> encoding) {
        return new Float32Array(floats, encoding);
    }

    public static Float64Array float64Array(double[] floats, Deque<Encoding<?>> encoding) {
        return new Float64Array(floats, encoding);
    }

    public static Int8Array int8Array(int[] ints, Deque<Encoding<?>> encoding) {
        return new Int8Array(ints, encoding);
    }

    public static Int16Array int16Array(int[] ints, Deque<Encoding<?>> encoding) {
        return new Int16Array(ints, encoding);
    }

    public static Int32Array int32Array(int[] ints, Deque<Encoding<?>> encoding) {
        return new Int32Array(ints, encoding);
    }

    public static Uint8Array uint8Array(int[] ints, Deque<Encoding<?>> encoding) {
        return new Uint8Array(ints, encoding);
    }

    public static Uint16Array uint16Array(int[] ints, Deque<Encoding<?>> encoding) {
        return new Uint16Array(ints, encoding);
    }

    public static Uint32Array uint32Array(int[] ints, Deque<Encoding<?>> encoding) {
        return new Uint32Array(ints, encoding);
    }

    public static StringArray stringArray(String[] strings, Deque<Encoding<?>> encoding) {
        return new StringArray(strings, encoding);
    }

    public static ByteArray byteArray(byte[] bytes, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new ByteArray(bytes, (Deque<Encoding<?>>)encoding);
    }

    public static Float32Array float32Array(double[] floats, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Float32Array(floats, (Deque<Encoding<?>>)encoding);
    }

    public static Float64Array float64Array(double[] floats, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Float64Array(floats, (Deque<Encoding<?>>)encoding);
    }

    public static Int8Array int8Array(int[] ints, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Int8Array(ints, (Deque<Encoding<?>>)encoding);
    }

    public static Int16Array int16Array(int[] ints, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Int16Array(ints, (Deque<Encoding<?>>)encoding);
    }

    public static Int32Array int32Array(int[] ints, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Int32Array(ints, (Deque<Encoding<?>>)encoding);
    }

    public static Uint8Array uint8Array(int[] ints, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Uint8Array(ints, (Deque<Encoding<?>>)encoding);
    }

    public static Uint16Array uint16Array(int[] ints, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Uint16Array(ints, (Deque<Encoding<?>>)encoding);
    }

    public static Uint32Array uint32Array(int[] ints, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new Uint32Array(ints, (Deque<Encoding<?>>)encoding);
    }

    public static StringArray stringArray(String[] strings, Encoding<?> enc) {
        ArrayDeque encoding = new ArrayDeque();
        encoding.add(enc);
        return new StringArray(strings, (Deque<Encoding<?>>)encoding);
    }

    public static FloatArray floatArray(int type, int size) {
        double[] data = new double[size];
        return type == 32 ? new Float32Array(data) : new Float64Array(data);
    }

    public static IntArray intArray(int type, int size) {
        int[] data = new int[size];
        switch (type) {
            case 1: {
                return new Int8Array(data);
            }
            case 2: {
                return new Int16Array(data);
            }
            case 3: {
                return new Int32Array(data);
            }
            case 4: {
                return new Uint8Array(data);
            }
            case 5: {
                return new Uint16Array(data);
            }
            case 6: {
                return new Uint32Array(data);
            }
        }
        throw new IllegalArgumentException("Unknown IntArray type " + type);
    }
}

