/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.codec.Classifier;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.StringArray;
import org.rcsb.cif.binary.encoding.StringArrayEncoding;

public class StringArrayCodec {
    public ByteArray encode(StringArray data, StringArrayEncoding encoding) {
        String[] input = data.getData();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<String> strings = new ArrayList<String>();
        int[] outputArray = new int[input.length];
        ArrayList<Integer> offsetList = new ArrayList<Integer>();
        offsetList.add(0);
        int accLength = 0;
        int i = 0;
        for (String s : input) {
            int index;
            if (s == null) {
                outputArray[i++] = -1;
                continue;
            }
            if (map.containsKey(s)) {
                index = (Integer)map.get(s);
                outputArray[i++] = index;
                continue;
            }
            accLength += s.length();
            index = strings.size();
            strings.add(s);
            map.put(s, index);
            offsetList.add(accLength);
            outputArray[i++] = index;
        }
        int[] offsetArray = new int[offsetList.size()];
        for (int j = 0; j < offsetList.size(); ++j) {
            offsetArray[j] = (Integer)offsetList.get(j);
        }
        Int32Array offsetPlain = EncodedDataFactory.int32Array(offsetArray);
        EncodingStrategyHint offsetHint = Classifier.classify(offsetPlain);
        ByteArray offsets = Classifier.encode(offsetPlain, offsetHint.getEncoding());
        Int32Array outputPlain = EncodedDataFactory.int32Array(outputArray);
        EncodingStrategyHint outputHint = Classifier.classify(outputPlain);
        ByteArray output = Classifier.encode(outputPlain, outputHint.getEncoding());
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        encoding.setOffsets(offsets.getData());
        encoding.setOffsetEncoding(offsets.getEncoding());
        encoding.setStringData(String.join((CharSequence)"", strings));
        encoding.setDataEncoding(output.getEncoding());
        enc.add(encoding);
        return EncodedDataFactory.byteArray(output.getData(), enc);
    }

    public StringArray decode(ByteArray data, StringArrayEncoding encoding) {
        String stringData = encoding.getStringData();
        int[] offsets = (int[])EncodedDataFactory.byteArray(encoding.getOffsets(), encoding.getOffsetEncoding()).decode().getData();
        data.setEncoding(encoding.getDataEncoding());
        int[] indices = (int[])data.decode().getData();
        String[] strings = new String[offsets.length];
        strings[0] = "";
        for (int i = 1; i < offsets.length; ++i) {
            strings[i] = stringData.substring(offsets[i - 1], offsets[i]);
        }
        int offset = 0;
        String[] result = new String[indices.length];
        for (int index : indices) {
            result[offset++] = strings[index + 1];
        }
        return EncodedDataFactory.stringArray(result, data.getEncoding());
    }
}

