/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.util.ArrayDeque;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.encoding.IntervalQuantizationEncoding;

public class IntervalQuantizationCodec {
    public Int32Array encode(FloatArray data, IntervalQuantizationEncoding encoding) {
        double[] input = data.getData();
        int min = encoding.getMin();
        int max = encoding.getMax();
        int numSteps = encoding.getNumSteps();
        int srcType = data.getType();
        if (input.length == 0) {
            ArrayDeque enc = new ArrayDeque(data.getEncoding());
            enc.add(encoding);
            encoding.setSrcType(3);
            return EncodedDataFactory.int32Array(new int[0], enc);
        }
        if (max < min) {
            int t = min;
            min = max;
            max = t;
        }
        double delta = (double)(max - min) / ((double)numSteps - 1.0);
        int[] output = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            double v = input[i];
            output[i] = v <= (double)min ? 0 : (v >= (double)max ? numSteps - 1 : (delta == 0.0 ? 0 : (int)Math.round((v - (double)min) / delta)));
        }
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        encoding.setSrcType(srcType);
        enc.add(encoding);
        return EncodedDataFactory.int32Array(output, enc);
    }

    public FloatArray decode(Int32Array data, IntervalQuantizationEncoding encoding) {
        int min = encoding.getMin();
        int max = encoding.getMax();
        int numSteps = encoding.getNumSteps();
        int srcType = encoding.getSrcType();
        double delta = (double)(max - min) / ((double)numSteps - 1.0);
        int[] intData = data.getData();
        double[] output = new double[intData.length];
        for (int i = 0; i < intData.length; ++i) {
            output[i] = (double)min + delta * (double)intData[i];
        }
        return srcType == 32 ? EncodedDataFactory.float32Array(output, data.getEncoding()) : EncodedDataFactory.float64Array(output, data.getEncoding());
    }
}

