/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.util.ArrayDeque;
import java.util.stream.IntStream;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.encoding.IntegerPackingEncoding;

public class IntegerPackingCodec {
    public IntArray encode(Int32Array data, IntegerPackingEncoding encoding) {
        int[] input = data.getData();
        Packing packing = this.determinePacking(input);
        if (packing.bytesPerElement == 4) {
            ArrayDeque enc = new ArrayDeque(data.getEncoding());
            encoding.setByteCount(4);
            encoding.setUnsigned(false);
            encoding.setSrcSize(input.length);
            enc.add(encoding);
            return EncodedDataFactory.int32Array(input, enc);
        }
        int upperLimit = packing.signed ? (packing.bytesPerElement == 1 ? 127 : Short.MAX_VALUE) : (packing.bytesPerElement == 1 ? 255 : 65535);
        int lowerLimit = -upperLimit - 1;
        int[] outputArray = new int[packing.size];
        int j = 0;
        for (int i1 : input) {
            int value = i1;
            if (value >= 0) {
                while (value >= upperLimit) {
                    outputArray[j] = upperLimit;
                    ++j;
                    value -= upperLimit;
                }
            } else {
                while (value <= lowerLimit) {
                    outputArray[j] = lowerLimit;
                    ++j;
                    value -= lowerLimit;
                }
            }
            outputArray[j] = value;
            ++j;
        }
        AbstractEncodedData output = packing.signed ? (packing.bytesPerElement == 1 ? EncodedDataFactory.int8Array(outputArray) : EncodedDataFactory.int16Array(outputArray)) : (packing.bytesPerElement == 1 ? EncodedDataFactory.uint8Array(outputArray) : EncodedDataFactory.uint16Array(outputArray));
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        encoding.setByteCount(packing.bytesPerElement);
        encoding.setUnsigned(!packing.signed);
        encoding.setSrcSize(data.length());
        enc.add(encoding);
        output.setEncoding(enc);
        return output;
    }

    private Packing determinePacking(int[] input) {
        boolean signed = IntStream.of(input).anyMatch(i -> i < 0);
        int size8 = this.packingSize(input, signed ? 127 : 255);
        int size16 = this.packingSize(input, signed ? Short.MAX_VALUE : 65535);
        if (input.length * 4 < size16 * 2) {
            return new Packing(signed, input.length, 4);
        }
        if (size16 * 2 < size8) {
            return new Packing(signed, size16, 2);
        }
        return new Packing(signed, size8, 1);
    }

    private int packingSize(int[] input, int upperLimit) {
        int lowerLimit = -upperLimit - 1;
        int size = 0;
        for (int value : input) {
            if (value == 0) {
                ++size;
                continue;
            }
            if (value > 0) {
                size = (int)((double)size + Math.ceil((double)value / (double)upperLimit));
                if (value % upperLimit != 0) continue;
                ++size;
                continue;
            }
            size = (int)((double)size + Math.ceil((double)value / (double)lowerLimit));
            if (value % lowerLimit != 0) continue;
            ++size;
        }
        return size;
    }

    public Int32Array decode(IntArray data, IntegerPackingEncoding encoding) {
        int upperLimit;
        int[] input = data.getData();
        int byteCount = encoding.getByteCount();
        boolean unsigned = encoding.isUnsigned();
        int srcSize = encoding.getSrcSize();
        if (input.length == srcSize && byteCount == 4) {
            Int32Array output = EncodedDataFactory.int32Array(input, data.getEncoding());
            output.setEncoding(data.getEncoding());
            return output;
        }
        int lowerLimit = 0;
        if (unsigned) {
            upperLimit = byteCount == 1 ? 255 : 65535;
        } else {
            upperLimit = byteCount == 1 ? 127 : Short.MAX_VALUE;
            lowerLimit = -upperLimit - 1;
        }
        int n = input.length;
        int[] output = new int[srcSize];
        int i = 0;
        int j = 0;
        while (i < n) {
            int value = 0;
            int t = input[i];
            while (unsigned ? t == upperLimit : t == upperLimit || t == lowerLimit) {
                value += t;
                t = input[++i];
            }
            output[j] = value += t;
            ++i;
            ++j;
        }
        return EncodedDataFactory.int32Array(output, data.getEncoding());
    }

    static class Packing {
        final boolean signed;
        final int size;
        final int bytesPerElement;

        Packing(boolean signed, int size, int bytesPerElement) {
            this.signed = signed;
            this.size = size;
            this.bytesPerElement = bytesPerElement;
        }
    }
}

