/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.util.ArrayDeque;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;

public class FixedPointCodec {
    public Int32Array encode(FloatArray data, FixedPointEncoding encoding) {
        int srcType = data.getType();
        int factor = encoding.getFactor();
        double[] floatData = data.getData();
        int[] outputArray = new int[floatData.length];
        for (int i = 0; i < floatData.length; ++i) {
            outputArray[i] = (int)Math.round(floatData[i] * (double)factor);
        }
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        encoding.setSrcType(srcType);
        enc.add(encoding);
        return EncodedDataFactory.int32Array(outputArray, enc);
    }

    public FloatArray decode(Int32Array data, FixedPointEncoding encoding) {
        int srcType = encoding.getSrcType();
        double f = 1.0 / (double)encoding.getFactor();
        int[] intData = data.getData();
        double[] outputArray = new double[intData.length];
        for (int i = 0; i < intData.length; ++i) {
            outputArray[i] = (double)intData[i] * f;
        }
        return srcType == 32 ? EncodedDataFactory.float32Array(outputArray, data.getEncoding()) : EncodedDataFactory.float64Array(outputArray, data.getEncoding());
    }
}

