/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.util.ArrayDeque;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.data.SignedIntArray;
import org.rcsb.cif.binary.encoding.DeltaEncoding;

public class DeltaCodec {
    public <T extends SignedIntArray> T encode(T data, DeltaEncoding encoding) {
        int srcType = data.getType();
        int[] inputArray = data.getData();
        if (inputArray.length == 0) {
            IntArray output = EncodedDataFactory.intArray(srcType, 0);
            return this.create(data, encoding, srcType, output, 0);
        }
        IntArray output = EncodedDataFactory.intArray(srcType, inputArray.length);
        int[] outputArray = output.getData();
        int origin = inputArray[0];
        outputArray[0] = inputArray[0];
        for (int i = 1; i < inputArray.length; ++i) {
            outputArray[i] = inputArray[i] - inputArray[i - 1];
        }
        outputArray[0] = 0;
        return this.create(data, encoding, srcType, output, origin);
    }

    private <T extends SignedIntArray> T create(T data, DeltaEncoding encoding, int srcType, IntArray output, int i2) {
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        encoding.setOrigin(i2);
        encoding.setSrcType(srcType);
        enc.add(encoding);
        output.setEncoding(enc);
        return (T)((SignedIntArray)output);
    }

    public <T extends SignedIntArray> T decode(T data, DeltaEncoding encoding) {
        int[] input = data.getData();
        int origin = encoding.getOrigin();
        int srcType = encoding.getSrcType();
        SignedIntArray output = (SignedIntArray)EncodedDataFactory.intArray(srcType, input.length);
        output.setEncoding(data.getEncoding());
        int n = input.length;
        if (n == 0) {
            return (T)output;
        }
        int[] outputArray = output.getData();
        outputArray[0] = input[0] + origin;
        for (int i = 1; i < n; ++i) {
            outputArray[i] = input[i] + outputArray[i - 1];
        }
        return (T)output;
    }
}

