/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.rcsb.cif.binary.codec.ByteArrayCodec;
import org.rcsb.cif.binary.codec.DeltaCodec;
import org.rcsb.cif.binary.codec.FixedPointCodec;
import org.rcsb.cif.binary.codec.IntegerPackingCodec;
import org.rcsb.cif.binary.codec.IntervalQuantizationCodec;
import org.rcsb.cif.binary.codec.MessagePackCodec;
import org.rcsb.cif.binary.codec.RunLengthCodec;
import org.rcsb.cif.binary.codec.StringArrayCodec;
import org.rcsb.cif.binary.data.EncodedData;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.DeltaEncoding;
import org.rcsb.cif.binary.encoding.Encoding;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;
import org.rcsb.cif.binary.encoding.IntegerPackingEncoding;
import org.rcsb.cif.binary.encoding.IntervalQuantizationEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;
import org.rcsb.cif.binary.encoding.StringArrayEncoding;

public class Codec {
    public static final String CODEC_NAME = "ciftools-java";
    public static final String VERSION = "0.3.0";
    public static final String MIN_VERSION = "0.3";
    public static final ByteArrayCodec BYTE_ARRAY_CODEC = new ByteArrayCodec();
    public static final DeltaCodec DELTA_CODEC = new DeltaCodec();
    public static final FixedPointCodec FIXED_POINT_CODEC = new FixedPointCodec();
    public static final IntegerPackingCodec INTEGER_PACKING_CODEC = new IntegerPackingCodec();
    public static final IntervalQuantizationCodec INTERVAL_QUANTIZATION_CODEC = new IntervalQuantizationCodec();
    public static final RunLengthCodec RUN_LENGTH_CODEC = new RunLengthCodec();
    public static final StringArrayCodec STRING_ARRAY_CODEC = new StringArrayCodec();
    public static final MessagePackCodec MESSAGE_PACK_CODEC = new MessagePackCodec();

    public static EncodedData<?> decode(EncodedData<?> encodedData) {
        EncodedData<?> current = encodedData;
        while (current.hasNextDecodingStep()) {
            Encoding<?> encoding = current.getEncoding().removeLast();
            current = encoding.decode(current);
        }
        return current;
    }

    public static Object decode(Map<String, Object> encodedData) {
        EncodedData<byte[]> current = EncodedDataFactory.byteArray((byte[])encodedData.get("data"));
        Object[] encodingMaps = (Object[])encodedData.get("encoding");
        for (int i = encodingMaps.length - 1; i >= 0; --i) {
            Map map = (Map)encodingMaps[i];
            Encoding<?> encoding = Codec.wrap(map);
            current = encoding.decode(current);
        }
        return current.getData();
    }

    private static Encoding<?> wrap(Map<String, Object> encoding) {
        String kind;
        switch (kind = (String)encoding.get("kind")) {
            case "ByteArray": {
                return new ByteArrayEncoding(encoding);
            }
            case "FixedPoint": {
                return new FixedPointEncoding(encoding);
            }
            case "IntervalQuantization": {
                return new IntervalQuantizationEncoding(encoding);
            }
            case "RunLength": {
                return new RunLengthEncoding(encoding);
            }
            case "Delta": {
                return new DeltaEncoding(encoding);
            }
            case "IntegerPacking": {
                return new IntegerPackingEncoding(encoding);
            }
            case "StringArray": {
                Deque<Encoding<?>> outputEncoding = Codec.wrap(encoding.get("dataEncoding"));
                Deque<Encoding<?>> offsetEncoding = Codec.wrap(encoding.get("offsetEncoding"));
                return new StringArrayEncoding(encoding, outputEncoding, offsetEncoding);
            }
        }
        throw new IllegalArgumentException("Unsupported Encoding kind: " + kind);
    }

    private static Deque<Encoding<?>> wrap(Object rawEncodingMap) {
        Object[] encodingMap = (Object[])rawEncodingMap;
        ArrayDeque encodings = new ArrayDeque();
        for (Object o : encodingMap) {
            encodings.add(Codec.wrap((Map)o));
        }
        return encodings;
    }
}

