/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.nio.ByteOrder;
import java.util.ArrayDeque;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.Float32Array;
import org.rcsb.cif.binary.data.Int16Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.Int8Array;
import org.rcsb.cif.binary.data.NumberArray;
import org.rcsb.cif.binary.data.Uint16Array;
import org.rcsb.cif.binary.data.Uint32Array;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;

public class ByteArrayCodec {
    private static final boolean IS_NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public <D> ByteArray encode(NumberArray<D> data, ByteArrayEncoding encoding) {
        int type = this.determineType(data);
        byte[] bytes = ByteArrayCodec.ensureOrder(data.toByteArray(), data.getNumberOfBytes());
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        encoding.setType(type);
        enc.add(encoding);
        return EncodedDataFactory.byteArray(bytes, enc);
    }

    private int determineType(NumberArray<?> data) {
        if (data instanceof Int8Array) {
            return 1;
        }
        if (data instanceof Int16Array) {
            return 2;
        }
        if (data instanceof Int32Array) {
            return 3;
        }
        if (data instanceof Uint8Array) {
            return 4;
        }
        if (data instanceof Uint16Array) {
            return 5;
        }
        if (data instanceof Uint32Array) {
            return 6;
        }
        if (data instanceof Float32Array) {
            return 32;
        }
        return 33;
    }

    private static byte[] flipByteOrder(byte[] data, int bytes) {
        byte[] buffer = new byte[data.length];
        int n = data.length;
        for (int i = 0; i < n; i += bytes) {
            for (int j = 0; j < bytes; ++j) {
                buffer[i + bytes - j - 1] = data[i + j];
            }
        }
        return buffer;
    }

    private static byte[] ensureOrder(byte[] bytes, int numberOfBytes) {
        if (!IS_NATIVE_LITTLE_ENDIAN) {
            bytes = ByteArrayCodec.flipByteOrder(bytes, numberOfBytes);
        }
        return bytes;
    }

    public NumberArray<?> decode(ByteArray data, ByteArrayEncoding encoding) {
        int type = encoding.getType();
        switch (type) {
            case 1: {
                return data.toInt8Array(data.getEncoding());
            }
            case 2: {
                return data.toInt16Array(data.getEncoding());
            }
            case 3: {
                return data.toInt32Array(data.getEncoding());
            }
            case 4: {
                return data.toUint8Array(data.getEncoding());
            }
            case 5: {
                return data.toUint16Array(data.getEncoding());
            }
            case 6: {
                return data.toUint32Array(data.getEncoding());
            }
            case 32: {
                return data.toFloat32Array(data.getEncoding());
            }
            case 33: {
                return data.toFloat64Array(data.getEncoding());
            }
        }
        throw new IllegalArgumentException("Unsupported byte type " + type);
    }
}

