/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.codec.Classifier;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.EncodedDataFactory;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;
import org.rcsb.cif.binary.encoding.StringArrayEncoding;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.ValueKind;

public class BinaryCifWriter {
    private final CifOptions options;

    public BinaryCifWriter(CifOptions options) {
        this.options = options;
    }

    public byte[] write(CifFile cifFile) {
        Map<String, Object> file = this.encodeFile(cifFile);
        return Codec.MESSAGE_PACK_CODEC.encode(file);
    }

    private Map<String, Object> encodeFile(CifFile cifFile) {
        LinkedHashMap<String, Object> file = new LinkedHashMap<String, Object>();
        file.put("encoder", this.options.getEncoder());
        file.put("version", "0.3.0");
        Object[] blocks = new Object[cifFile.getBlocks().size()];
        int blockCount = 0;
        file.put("dataBlocks", blocks);
        for (Block cifBlock : cifFile.getBlocks()) {
            LinkedHashMap<String, Object> block = new LinkedHashMap<String, Object>();
            String blockHeader = cifBlock.getBlockHeader();
            String header = blockHeader != null ? blockHeader.replaceAll("[ \n\t]", "").toUpperCase() : "UNKNOWN";
            block.put("header", header);
            List filteredCategoryNames = cifBlock.getCategoryNames().stream().filter(this.options::filterCategory).collect(Collectors.toList());
            Object[] categories = new Object[filteredCategoryNames.size()];
            int categoryCount = 0;
            block.put("categories", categories);
            blocks[blockCount++] = block;
            for (String categoryName : filteredCategoryNames) {
                Category cifCategory = cifBlock.getCategory(categoryName);
                int rowCount = cifCategory.getRowCount();
                if (rowCount == 0) continue;
                LinkedHashMap<String, Object> category = new LinkedHashMap<String, Object>();
                category.put("name", "_" + cifCategory.getCategoryName());
                Object[] columns = cifCategory.getColumnNames().stream().filter(columnName -> this.options.filterColumn(categoryName, (String)columnName)).map(cifCategory::getColumn).map(cifColumn -> this.encodeColumn(categoryName, (Column)cifColumn)).toArray();
                category.put("columns", columns);
                category.put("rowCount", rowCount);
                categories[categoryCount++] = category;
            }
        }
        return file;
    }

    private ByteArray encode(String categoryName, String columnName, Float64Array column) {
        Optional<EncodingStrategyHint> optional = this.options.getEncodingStrategyHint(categoryName, columnName);
        EncodingStrategyHint hint = optional.orElseGet(column::classify);
        String encoding = hint.getEncoding() != null ? hint.getEncoding() : Classifier.classify(column).getEncoding();
        EncodingStrategyHint precisionClassification = Classifier.classifyPrecision(column);
        if ("byte".equals(precisionClassification.getEncoding())) {
            return column.encode(new ByteArrayEncoding(column.getType()));
        }
        int multiplier = BinaryCifWriter.getMultiplier(hint.getPrecision() != null ? hint.getPrecision() : precisionClassification.getPrecision());
        Int32Array fixedPoint = column.encode(new FixedPointEncoding(multiplier));
        return Classifier.encode(fixedPoint, encoding);
    }

    private static int getMultiplier(int mantissaDigits) {
        int m = 1;
        for (int i = 0; i < mantissaDigits; ++i) {
            m *= 10;
        }
        return m;
    }

    private ByteArray encode(String categoryName, String columnName, Int32Array column) {
        Optional<String> optional = this.options.getEncodingStrategyHint(categoryName, columnName).map(EncodingStrategyHint::getEncoding);
        String encoding = optional.orElseGet(() -> Classifier.classify(column).getEncoding());
        return Classifier.encode(column, encoding);
    }

    private Map<String, Object> encodeColumn(String categoryName, Column cifColumn) {
        if (cifColumn instanceof FloatColumn) {
            FloatColumn floatCol = (FloatColumn)cifColumn;
            double[] array = floatCol.getBinaryData() != null ? floatCol.getBinaryData() : floatCol.values().toArray();
            ByteArray byteArray = this.encode(categoryName, cifColumn.getColumnName(), EncodedDataFactory.float64Array(array));
            return this.encodeColumn(cifColumn, byteArray);
        }
        if (cifColumn instanceof IntColumn) {
            IntColumn intCol = (IntColumn)cifColumn;
            int[] array = intCol.getBinaryData() != null ? intCol.getBinaryData() : intCol.values().toArray();
            ByteArray byteArray = this.encode(categoryName, cifColumn.getColumnName(), EncodedDataFactory.int32Array(array));
            return this.encodeColumn(cifColumn, byteArray);
        }
        StrColumn strCol = (StrColumn)cifColumn;
        String[] array = strCol.getBinaryData() != null ? strCol.getBinaryData() : (String[])strCol.values().toArray(String[]::new);
        ByteArray byteArray = EncodedDataFactory.stringArray(array).encode(new StringArrayEncoding());
        return this.encodeColumn(cifColumn, byteArray);
    }

    private Map<String, Object> encodeColumn(Column cifField, ByteArray byteArray) {
        String name = cifField.getColumnName();
        int[] maskArray = new int[cifField.getRowCount()];
        Uint8Array mask = EncodedDataFactory.uint8Array(maskArray);
        boolean allPresent = true;
        for (int row = 0; row < maskArray.length; ++row) {
            ValueKind kind = cifField.getValueKind(row);
            if (kind != ValueKind.PRESENT) {
                maskArray[row] = (byte)kind.ordinal();
                allPresent = false;
                continue;
            }
            maskArray[row] = (byte)ValueKind.PRESENT.ordinal();
        }
        LinkedHashMap<String, A[]> encodedMap = new LinkedHashMap<String, A[]>();
        encodedMap.put("encoding", byteArray.getEncoding().stream().map(this::wrap).toArray(Map[]::new));
        encodedMap.put("data", byteArray.getData());
        LinkedHashMap<String, Object[]> maskData = new LinkedHashMap<String, Object[]>();
        if (!allPresent) {
            ByteArray maskRLE = mask.encode(new RunLengthEncoding()).encode(new ByteArrayEncoding());
            if (maskRLE.getData().length < mask.getData().length) {
                RunLengthEncoding rle = (RunLengthEncoding)maskRLE.getEncoding().getFirst();
                LinkedHashMap<String, Object> encoding1 = new LinkedHashMap<String, Object>();
                encoding1.put("kind", "RunLength");
                encoding1.put("srcType", rle.getSrcType());
                encoding1.put("srcSize", rle.getSrcSize());
                LinkedHashMap<String, Object> encoding2 = new LinkedHashMap<String, Object>();
                encoding2.put("kind", "ByteArray");
                encoding2.put("type", 3);
                maskData.put("encoding", new Object[]{encoding1, encoding2});
                maskData.put("data", maskRLE.getData());
            } else {
                ByteArray encodedMask = mask.encode(new ByteArrayEncoding(4));
                LinkedHashMap<String, Object> encoding = new LinkedHashMap<String, Object>();
                encoding.put("kind", "ByteArray");
                encoding.put("type", 4);
                maskData.put("encoding", new Object[]{encoding});
                maskData.put("data", encodedMask.getData());
            }
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", name);
        map.put("data", encodedMap);
        map.put("mask", maskData);
        return map;
    }

    private Map<String, Object> wrap(Object object) {
        try {
            LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
            for (Field field : object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object[] content = field.get(object);
                if (content instanceof Map) {
                    content = this.wrap(content);
                } else if (content instanceof Collection) {
                    Collection list = (Collection)content;
                    content = list.stream().map(this::wrap).toArray();
                } else if (this.isObjectArray(content)) {
                    Object[] array = content;
                    Object[] contentArray = new Object[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        contentArray[i] = this.wrap(array[i]);
                    }
                    content = contentArray;
                }
                out.put(field.getName(), content);
            }
            return out;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not convert Encoding to Map representation", e);
        }
    }

    private boolean isObjectArray(Object content) {
        if (content == null) {
            return false;
        }
        if (!content.getClass().isArray()) {
            return false;
        }
        return !(content instanceof int[]) && !(content instanceof double[]) && !(content instanceof byte[]) && !(content instanceof char[]);
    }
}

