/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.builder.CategoryBuilder;
import org.rcsb.cif.model.builder.CifBuilder;
import org.rcsb.cif.model.builder.FloatColumnBuilder;
import org.rcsb.cif.model.generated.AtomSite;

public class Demo {
    public static void main(String[] args) throws IOException {
        Demo.parseFile();
        System.out.println();
        Demo.buildModel();
    }

    private static void parseFile() throws IOException {
        String pdbId = "1acj";
        boolean parseBinary = true;
        CifFile cifFile = parseBinary ? CifIO.readFromURL(new URL("https://models.rcsb.org/" + pdbId + ".bcif")) : CifIO.readFromURL(new URL("https://files.rcsb.org/download/" + pdbId + ".cif"));
        Block data = cifFile.getFirstBlock();
        AtomSite atomSite = data.getAtomSite();
        FloatColumn cartnX = atomSite.getCartnX();
        String entryId = data.getEntry().getId().get(0);
        System.out.println(entryId);
        OptionalDouble averageCartnX = cartnX.values().average();
        averageCartnX.ifPresent(System.out::println);
        OptionalInt lastLabelSeqId = atomSite.getLabelSeqId().values().max();
        lastLabelSeqId.ifPresent(System.out::println);
        Optional<String> groupPdb = data.getAtomSite().getGroupPDB().values().findFirst();
        groupPdb.ifPresent(System.out::println);
    }

    private static void buildModel() throws IOException {
        CifFile cifFile = ((CategoryBuilder.AtomSiteBuilder)((FloatColumnBuilder)((CategoryBuilder.AtomSiteBuilder)((FloatColumnBuilder)new CifBuilder().enterBlock("1EXP").enterEntry().enterId().add("1EXP").leaveColumn().leaveCategory().enterAtomSite().enterCartnX().add(1.0, -2.4, 4.5).markNextUnknown()).add(-3.14, 5.0).leaveColumn()).enterCartnY().add(0.0, -1.0, 2.72).markNextNotPresent()).add(42.0, 100.0).leaveColumn()).leaveCategory().leaveBlock().leaveFile();
        System.out.println(new String(CifIO.writeText(cifFile)));
        System.out.println(cifFile.getFirstBlock().getEntry().getId().get(0));
        cifFile.getFirstBlock().getAtomSite().getCartnX().values().forEach(System.out::println);
    }
}

