/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;

public class TextCategory
implements Category {
    private final String name;
    private final int rowCount;
    private final Map<String, Column<?>> textFields;

    public TextCategory(String name, Map<String, Column<?>> textColumns) {
        this.name = name;
        this.rowCount = textColumns.values().stream().findFirst().map(Column::getRowCount).orElse(0);
        this.textFields = textColumns;
    }

    @Override
    public String getCategoryName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Column<?> getColumn(String name) {
        return this.textFields.getOrDefault(name, new Column.EmptyColumn(name));
    }

    @Override
    public Map<String, Column<?>> getColumns() {
        return this.textFields;
    }

    @Override
    public List<String> getColumnNames() {
        return new ArrayList<String>(this.textFields.keySet());
    }
}

