/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.encoding.Encoding;

public class RunLengthEncoding
implements Encoding<IntArray, Int32Array> {
    private int srcType;
    private int srcSize;

    public RunLengthEncoding() {
    }

    public RunLengthEncoding(int srcType, int srcSize) {
        this.srcType = srcType;
        this.srcSize = srcSize;
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "RunLength");
        map.put("srcType", this.srcType);
        map.put("srcSize", this.srcSize);
        return map;
    }

    @Override
    public IntArray decode(Int32Array data) {
        int[] input = data.getData();
        if (input.length == 0) {
            return data;
        }
        int dataOffset = 0;
        IntArray output = IntArray.create(this.srcType, this.srcSize);
        output.setEncoding(data.getEncoding());
        int[] outputArray = output.getData();
        for (int i = 0; i < data.length(); i += 2) {
            int value = input[i];
            int length = input[i + 1];
            for (int j = 0; j < length; ++j) {
                outputArray[dataOffset++] = value;
            }
        }
        return output;
    }

    @Override
    public Int32Array encode(IntArray data) {
        int[] input = data.getData();
        if (input.length == 0) {
            ArrayDeque enc = new ArrayDeque(data.getEncoding());
            this.srcType = 3;
            this.srcSize = 0;
            enc.add(this);
            return new Int32Array(new int[0], (Deque<Encoding<?, ?>>)enc);
        }
        int fullLength = 2;
        for (int i = 1; i < input.length; ++i) {
            if (input[i - 1] == input[i]) continue;
            fullLength += 2;
        }
        int[] output = new int[fullLength];
        int offset = 0;
        int runLength = 1;
        for (int i = 1; i < input.length; ++i) {
            if (input[i - 1] != input[i]) {
                output[offset] = input[i - 1];
                output[offset + 1] = runLength;
                runLength = 1;
                offset += 2;
                continue;
            }
            ++runLength;
        }
        output[offset] = input[input.length - 1];
        output[offset + 1] = runLength;
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        this.srcType = 3;
        this.srcSize = input.length;
        enc.add(this);
        return new Int32Array(output, (Deque<Encoding<?, ?>>)enc);
    }

    public String toString() {
        return "RunLengthEncoding{srcType=" + this.srcType + ", srcSize=" + this.srcSize + '}';
    }
}

