/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.SignedIntArray;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.DeltaEncoding;
import org.rcsb.cif.binary.encoding.Encoding;

public class Int16Array
extends AbstractEncodedData<int[]>
implements SignedIntArray<Int16Array> {
    private static final int NUMBER_OF_BYTES = 2;
    static final int TYPE = 2;

    public Int16Array(int[] data) {
        this(data, (Deque<Encoding<?, ?>>)new ArrayDeque());
    }

    public Int16Array(int[] data, Deque<Encoding<?, ?>> encoding) {
        super(data, encoding);
    }

    public Int16Array(ByteArray array) {
        super(Int16Array.formArray(array.getData()), array.getEncoding());
    }

    private static int[] formArray(byte[] array) {
        int[] ints = new int[array.length / 2];
        ByteBuffer byteBuffer = ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = byteBuffer.getShort();
        }
        return ints;
    }

    @Override
    public int[] getData() {
        return (int[])this.data;
    }

    @Override
    public int length() {
        return this.getData().length;
    }

    @Override
    public byte[] toByteArray() {
        return Int16Array.int16ToByteArray(this.getData());
    }

    static byte[] int16ToByteArray(int[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * 2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i : data) {
            buffer.putShort((short)i);
        }
        return buffer.array();
    }

    @Override
    public int getNumberOfBytes() {
        return 2;
    }

    @Override
    public int getType() {
        return 2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + Arrays.toString(this.getData());
    }

    @Override
    public Int16Array encode(DeltaEncoding<Int16Array> encoding) {
        return encoding.encode(this);
    }

    @Override
    public ByteArray encode() {
        return ByteArrayEncoding.INT16.encode(this);
    }

    @Override
    public Int16Array decode(DeltaEncoding<Int16Array> encoding) {
        return encoding.decode(this);
    }
}

