/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.EncodingStrategyHint;
import org.rcsb.cif.binary.Classifier;
import org.rcsb.cif.binary.codec.MessagePackCodec;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.StringArray;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.Encoding;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;
import org.rcsb.cif.binary.encoding.StringArrayEncoding;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.ValueKind;

public class BinaryCifWriter {
    private final CifOptions options;

    public BinaryCifWriter(CifOptions options) {
        this.options = options;
    }

    public byte[] write(CifFile cifFile) {
        Map<String, Object> file = this.encodeFile(cifFile);
        return MessagePackCodec.encode(file);
    }

    private Map<String, Object> encodeFile(CifFile cifFile) {
        LinkedHashMap<String, Object> file = new LinkedHashMap<String, Object>();
        file.put("encoder", this.options.getEncoder());
        file.put("version", "0.3.0");
        Object[] blocks = new Object[cifFile.getBlocks().size()];
        int blockCount = 0;
        file.put("dataBlocks", blocks);
        for (Block block : cifFile.getBlocks()) {
            LinkedHashMap<String, Object> block2 = new LinkedHashMap<String, Object>();
            String blockHeader = block.getBlockHeader();
            String header = blockHeader != null ? blockHeader.replaceAll("[ \n\t]", "").toUpperCase() : "UNKNOWN";
            block2.put("header", header);
            List filteredCategories = block.categories().filter(category -> this.options.filterCategory(category.getCategoryName())).collect(Collectors.toList());
            Object[] categories = new Object[filteredCategories.size()];
            int categoryCount = 0;
            block2.put("categories", categories);
            blocks[blockCount++] = block2;
            for (Category category2 : filteredCategories) {
                String categoryName = category2.getCategoryName();
                int rowCount = category2.getRowCount();
                if (rowCount == 0) continue;
                LinkedHashMap<String, Object> categoryMap = new LinkedHashMap<String, Object>();
                categoryMap.put("name", "_" + category2.getCategoryName());
                Object[] columns = category2.columns().filter(column -> this.options.filterColumn(categoryName, column.getColumnName())).map(column -> this.encodeColumn(categoryName, (Column<?>)column)).toArray();
                categoryMap.put("columns", columns);
                categoryMap.put("rowCount", rowCount);
                categories[categoryCount++] = categoryMap;
            }
        }
        return file;
    }

    private ByteArray encodeFloatArray(String categoryName, String columnName, Float64Array column) {
        Optional<EncodingStrategyHint> optional = this.options.getEncodingStrategyHint(categoryName, columnName);
        EncodingStrategyHint hint = optional.orElseGet(() -> Classifier.classify(column));
        String encoding = hint.getEncoding() != null ? hint.getEncoding() : Classifier.classify(column).getEncoding();
        EncodingStrategyHint precisionClassification = Classifier.classifyPrecision(column);
        if ("byte".equals(precisionClassification.getEncoding())) {
            return column.encode();
        }
        int multiplier = BinaryCifWriter.getMultiplier(hint.getPrecision() != null ? hint.getPrecision() : precisionClassification.getPrecision());
        Int32Array fixedPoint = column.encode(new FixedPointEncoding(multiplier));
        return Classifier.encode(fixedPoint, encoding);
    }

    private static int getMultiplier(int mantissaDigits) {
        int m = 1;
        for (int i = 0; i < mantissaDigits; ++i) {
            m *= 10;
        }
        return m;
    }

    private ByteArray encodeIntArray(String categoryName, String columnName, Int32Array column) {
        Optional<String> optional = this.options.getEncodingStrategyHint(categoryName, columnName).map(EncodingStrategyHint::getEncoding);
        String encoding = optional.orElseGet(() -> Classifier.classify(column).getEncoding());
        return Classifier.encode(column, encoding);
    }

    private Map<String, Object> encodeColumn(String categoryName, Column<?> cifColumn) {
        if (cifColumn instanceof FloatColumn) {
            FloatColumn floatCol = (FloatColumn)cifColumn;
            double[] array = (double[])floatCol.getArray();
            ByteArray byteArray = this.encodeFloatArray(categoryName, cifColumn.getColumnName(), new Float64Array(array));
            return this.encodeColumnUsingByteArray(cifColumn, byteArray);
        }
        if (cifColumn instanceof IntColumn) {
            IntColumn intCol = (IntColumn)cifColumn;
            int[] array = (int[])intCol.getArray();
            ByteArray byteArray = this.encodeIntArray(categoryName, cifColumn.getColumnName(), new Int32Array(array));
            return this.encodeColumnUsingByteArray(cifColumn, byteArray);
        }
        if (cifColumn instanceof StrColumn) {
            StrColumn strCol = (StrColumn)cifColumn;
            String[] array = (String[])strCol.getArray();
            ByteArray byteArray = new StringArray(array).encode(new StringArrayEncoding());
            return this.encodeColumnUsingByteArray(cifColumn, byteArray);
        }
        String[] array = (String[])cifColumn.stringData().toArray(String[]::new);
        ByteArray byteArray = new StringArray(array).encode(new StringArrayEncoding());
        return this.encodeColumnUsingByteArray(cifColumn, byteArray);
    }

    private Map<String, Object> encodeColumnUsingByteArray(Column<?> cifField, ByteArray byteArray) {
        String name = cifField.getColumnName();
        int[] maskArray = new int[cifField.getRowCount()];
        Uint8Array mask = new Uint8Array(maskArray);
        boolean allPresent = true;
        for (int row = 0; row < maskArray.length; ++row) {
            ValueKind kind = cifField.getValueKind(row);
            if (kind != ValueKind.PRESENT) {
                maskArray[row] = (byte)kind.ordinal();
                allPresent = false;
                continue;
            }
            maskArray[row] = (byte)ValueKind.PRESENT.ordinal();
        }
        LinkedHashMap<String, A[]> encodedMap = new LinkedHashMap<String, A[]>();
        encodedMap.put("encoding", byteArray.getEncoding().stream().map(Encoding::getMapRepresentation).toArray(Map[]::new));
        encodedMap.put("data", byteArray.getData());
        LinkedHashMap<String, Object[]> maskData = new LinkedHashMap<String, Object[]>();
        if (!allPresent) {
            ByteArray maskRLE = mask.encode(new RunLengthEncoding()).encode();
            if (maskRLE.getData().length < mask.getData().length) {
                RunLengthEncoding rle = (RunLengthEncoding)maskRLE.getEncoding().getFirst();
                maskData.put("encoding", new Object[]{rle.getMapRepresentation(), ByteArrayEncoding.INT32.getMapRepresentation()});
                maskData.put("data", maskRLE.getData());
            } else {
                ByteArray encodedMask = mask.encode();
                maskData.put("encoding", new Object[]{ByteArrayEncoding.UINT8.getMapRepresentation()});
                maskData.put("data", encodedMask.getData());
            }
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", name);
        map.put("data", encodedMap);
        map.put("mask", maskData);
        return map;
    }
}

