/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.ParsingException;
import org.rcsb.cif.binary.BinaryCifReader;
import org.rcsb.cif.binary.BinaryCifWriter;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.text.TextCifReader;
import org.rcsb.cif.text.TextCifWriter;

public class CifIO {
    private static final int BUFFER_SIZE = 65536;
    private static final CifOptions DEFAULT_OPTIONS = CifOptions.builder().build();
    private static final int GZIP_MAGIC = 31;
    private static final int BINARY_MAGIC = 131;

    public static CifFile readById(String pdbId) throws IOException {
        return CifIO.readById(pdbId, DEFAULT_OPTIONS);
    }

    public static CifFile readById(String pdbId, CifOptions options) throws IOException {
        try {
            return CifIO.readFromURL(new URL(String.format(options.getFetchUrl(), pdbId.toLowerCase())), options);
        }
        catch (ParsingException e) {
            throw new ParsingException("parsing failed - potentially wrong URL", e);
        }
    }

    public static CifFile readFromURL(URL url) throws IOException {
        return CifIO.readFromURL(url, DEFAULT_OPTIONS);
    }

    public static CifFile readFromURL(URL url, CifOptions options) throws IOException {
        return CifIO.readFromInputStream(url.openStream(), options);
    }

    public static CifFile readFromPath(Path path) throws IOException {
        return CifIO.readFromPath(path, DEFAULT_OPTIONS);
    }

    public static CifFile readFromPath(Path path, CifOptions options) throws IOException {
        return CifIO.readFromInputStream(Files.newInputStream(path, new OpenOption[0]), options);
    }

    public static CifFile readFromInputStream(InputStream inputStream) throws IOException {
        return CifIO.readFromInputStream(inputStream, DEFAULT_OPTIONS);
    }

    public static CifFile readFromInputStream(InputStream inputStream, CifOptions options) throws IOException {
        CifOptions.CifOptionsBuilder.FileFormat fileFormat;
        if (!(inputStream instanceof BufferedInputStream) && !(inputStream instanceof ByteArrayInputStream)) {
            inputStream = new BufferedInputStream(inputStream, 65536);
        }
        if ((fileFormat = options.getFileFormat()) == null) {
            return CifIO.readFromInputStreamByGuessingFileFormat(inputStream, options);
        }
        return CifIO.readFromInputStreamWithSpecifiedFileFormat(inputStream, options, fileFormat);
    }

    private static CifFile readFromInputStreamWithSpecifiedFileFormat(InputStream inputStream, CifOptions options, CifOptions.CifOptionsBuilder.FileFormat fileFormat) throws IOException {
        try {
            if (fileFormat == CifOptions.CifOptionsBuilder.FileFormat.BCIF_GZIPPED || fileFormat == CifOptions.CifOptionsBuilder.FileFormat.CIF_GZIPPED) {
                inputStream = new GZIPInputStream(inputStream, 65536);
            }
        }
        catch (ZipException e) {
            inputStream.close();
            throw new ParsingException("Not in GZIP format", e);
        }
        if (fileFormat == CifOptions.CifOptionsBuilder.FileFormat.BCIF_GZIPPED || fileFormat == CifOptions.CifOptionsBuilder.FileFormat.BCIF_PLAIN) {
            return new BinaryCifReader(options).read(inputStream);
        }
        return new TextCifReader(options).read(inputStream);
    }

    private static CifFile readFromInputStreamByGuessingFileFormat(InputStream inputStream, CifOptions options) throws IOException {
        boolean gzipped;
        int magicNumber = CifIO.readMagicNumber(inputStream);
        boolean bl = gzipped = 31 == magicNumber;
        if (gzipped) {
            return CifIO.readFromInputStream(new GZIPInputStream(inputStream, 65536), options);
        }
        if (magicNumber == 131) {
            return new BinaryCifReader(options).read(inputStream);
        }
        return new TextCifReader(options).read(inputStream);
    }

    private static int readMagicNumber(InputStream inputStream) throws IOException {
        inputStream.mark(1);
        int magicNumber = inputStream.read() & 0xFF;
        inputStream.reset();
        return magicNumber;
    }

    public static void writeBinary(CifFile cifFile, Path outputFile) throws IOException {
        CifIO.writeBinary(cifFile, outputFile, DEFAULT_OPTIONS);
    }

    public static void writeBinary(CifFile cifFile, Path outputFile, CifOptions options) throws IOException {
        Files.write(outputFile, CifIO.writeBinary(cifFile, options), new OpenOption[0]);
    }

    public static byte[] writeBinary(CifFile cifFile) throws IOException {
        return CifIO.writeBinary(cifFile, DEFAULT_OPTIONS);
    }

    public static byte[] writeBinary(CifFile cifFile, CifOptions options) throws IOException {
        byte[] raw = new BinaryCifWriter(options).write(cifFile);
        return options.isGzip() ? CifIO.compress(raw) : raw;
    }

    public static void writeText(CifFile cifFile, Path outputFile) throws IOException {
        CifIO.writeText(cifFile, outputFile, DEFAULT_OPTIONS);
    }

    public static void writeText(CifFile cifFile, Path outputFile, CifOptions options) throws IOException {
        Files.write(outputFile, CifIO.writeText(cifFile, options), new OpenOption[0]);
    }

    public static byte[] writeText(CifFile cifFile) throws IOException {
        return CifIO.writeText(cifFile, DEFAULT_OPTIONS);
    }

    public static byte[] writeText(CifFile cifFile, CifOptions options) throws IOException {
        byte[] raw = new TextCifWriter(options).write(cifFile);
        return options.isGzip() ? CifIO.compress(raw) : raw;
    }

    private static byte[] compress(byte[] bytes) throws IOException {
        byte[] output;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(bytes.length);){
            try (GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
                zipStream.write(bytes);
            }
            output = byteStream.toByteArray();
        }
        return output;
    }
}

