/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.RawIOBase;

public class BufferedReader
extends BufferedIOMixin {
    protected ByteBuffer buffer;

    public BufferedReader(RawIOBase rawIO, int bufferSize) {
        super(rawIO, bufferSize);
        rawIO.checkReadable();
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.clear();
    }

    @Override
    public int readinto(ByteBuffer bytes) {
        int size = bytes.remaining();
        if (size == 0) {
            return 0;
        }
        if (this.buffer.remaining() >= size) {
            int bufferLimit = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + size);
            bytes.put(this.buffer);
            this.buffer.limit(bufferLimit);
            return size;
        }
        bytes.put(this.buffer);
        this.buffer.clear();
        long read = this.rawIO.readinto(new ByteBuffer[]{bytes, this.buffer});
        return (int)(read -= (long)this.buffer.flip().limit());
    }

    @Override
    public ByteBuffer readall() {
        ByteBuffer remaining = this.rawIO.readall();
        if (!this.buffer.hasRemaining()) {
            return remaining;
        }
        ByteBuffer all = ByteBuffer.allocate(this.buffer.remaining() + remaining.remaining());
        all.put(this.buffer);
        this.clear();
        all.put(remaining);
        all.flip();
        return all;
    }

    @Override
    public ByteBuffer peek(int size) {
        if (this.buffer.remaining() < Math.min(size, this.bufferSize)) {
            if (this.buffer.position() == 0) {
                this.buffer.limit(this.buffer.capacity());
            } else {
                this.buffer.compact();
            }
            this.rawIO.readinto(this.buffer);
            this.buffer.flip();
        }
        return this.buffer;
    }

    @Override
    public int read1(ByteBuffer bytes) {
        int size = bytes.remaining();
        if (size == 0) {
            return 0;
        }
        if (this.bufferSize > 0) {
            this.peek(1);
            int bufferedSize = this.buffer.remaining();
            if (bufferedSize < size) {
                bytes.limit(bytes.position() + bufferedSize);
            }
        }
        return this.readinto(bytes);
    }

    @Override
    public long tell() {
        return this.rawIO.tell() - (long)this.buffer.remaining();
    }

    @Override
    public long seek(long pos, int whence) {
        if (whence == 1) {
            pos -= (long)this.buffer.remaining();
        }
        pos = this.rawIO.seek(pos, whence);
        this.clear();
        return pos;
    }

    @Override
    public boolean buffered() {
        return this.buffer.hasRemaining();
    }

    @Override
    public void clear() {
        this.buffer.clear().limit(0);
    }

    @Override
    public int write(ByteBuffer bytes) {
        this.checkClosed();
        this.checkWritable();
        return -1;
    }

    @Override
    public boolean writable() {
        return false;
    }
}

