/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.easymock.internal.invocationcontrol;

import java.lang.reflect.Method;
import java.util.Set;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.MocksControl;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockMethodInvocationControl<T>
implements MethodInvocationControl {
    private MockInvocationHandler invocationHandler;
    private Set<Method> mockedMethods;
    private T mockInstance;
    private boolean hasReplayed;
    private boolean hasVerified;

    public EasyMockMethodInvocationControl(MockInvocationHandler invocationHandler, Set<Method> methodsToMock, T mockInstance) {
        if (invocationHandler == null) {
            throw new IllegalArgumentException("Invocation Handler cannot be null.");
        }
        this.invocationHandler = invocationHandler;
        this.mockedMethods = methodsToMock;
        this.mockInstance = mockInstance;
    }

    public EasyMockMethodInvocationControl(MockInvocationHandler invocationHandler, Set<Method> methodsToMock) {
        this(invocationHandler, methodsToMock, null);
    }

    public boolean isMocked(Method method) {
        return this.mockedMethods == null || this.mockedMethods != null && this.mockedMethods.contains(method);
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        return this.invocationHandler.invoke(this.mockInstance == null ? proxy : this.mockInstance, method, arguments);
    }

    public MocksControl.MockType getMockType() {
        return (MocksControl.MockType)WhiteboxImpl.getInternalState((Object)this.invocationHandler.getControl(), MocksControl.MockType.class);
    }

    public synchronized Object replay(Object ... mocks) {
        if (!this.hasReplayed) {
            this.invocationHandler.getControl().replay();
            this.hasReplayed = true;
        }
        return null;
    }

    public synchronized Object verify(Object ... mocks) {
        if (!this.hasVerified) {
            this.invocationHandler.getControl().verify();
            this.hasVerified = true;
        }
        return null;
    }

    public synchronized Object reset(Object ... mocks) {
        this.invocationHandler.getControl().reset();
        this.hasReplayed = false;
        this.hasVerified = false;
        return null;
    }
}

