package org.planx.xpath.object;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;

/**
 * An object returned by an XPath expression.
 **/
public abstract class XObject extends Expression {

    /**
     * Evaluating an XObject just returns the object
     * ifself.
     **/
    public XObject evaluate(Context ctxt, Environment env, Navigator nav)
                                                   throws XPathException {
        return this;
    }

    /**
     * Converts this XObject to a boolean value.
     **/
    public abstract boolean booleanValue();
}
