package org.planx.xpath.expr.operator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.object.*;

/**
 * Equals operator
 **/
public class EqualOperator extends EqualityOperator {
    public EqualOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    protected boolean compare(XNodeSet s1, XNodeSet s2, Navigator navigator)
                                                      throws XPathException {

        // Hashes of set s1 is going to be stored,
        // so make sure it is the smallest

        if (s2.size() < s1.size()) {
            XNodeSet s3 = s1;
            s1 = s2;
            s2 = s3;
        }

        // Calculate hash codes for strings in s1 and store nodes

        Map hashes = new HashMap();

        for (int i = 0, size1 = s1.size(); i < size1; i++) {
            Object o1 = s1.get(i);
            String str1 = navigator.getStringValue(o1);
            Integer hash = new Integer(str1.hashCode());
            List objs = (List) hashes.get(hash);
            if (objs == null) {
                objs = new ArrayList(1);
                objs.add(o1);
                hashes.put(hash, objs);
            } else {
                if (!equalsAny(str1, objs, navigator)) {
                    objs.add(o1);
                }
            }
        }

        // Compare with s2

        for (int i = 0, size2 = s2.size(); i < size2; i++) {
            String str2 = navigator.getStringValue(s2.get(i));
            Integer hash = new Integer(str2.hashCode());
            List objs = (List) hashes.get(hash);
            if ((objs != null) && equalsAny(str2, objs, navigator)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Returns true of s is equal to the string value of any
     * node in hs.
     **/
    private boolean equalsAny(String s, List hs, Navigator nav)
                                         throws XPathException {
        for (int i = 0, size = hs.size(); i < size; i++) {
            String r = nav.getStringValue(hs.get(i));
            if (s.equals(r)) return true;
        }
        return false;
    }

    protected boolean compare(boolean v1, boolean v2) {
        return v1 == v2;
    }

    protected boolean compare(double v1, double v2) {
        return v1 == v2;
    }

    protected boolean compare(String v1, String v2) {
        return v2.equals(v1);
    }

    protected String operatorName() {
        return "=";
    }
}
