package org.planx.xpath.expr.axis;

import org.planx.xpath.XPathException;

/**
 * An iterator for axes.
 * AxisIterator does not extend {@link java.util.Iterator}
 * since {@link #next} throws a non-runtime exception.
 **/
public interface AxisIterator {
    /**
     * Returns <tt>true</tt> if the iteration has more elements. (In other
     * words, returns <tt>true</tt> if <tt>next</tt> would return an element
     * rather than throwing an exception.)
     *
     * @return <tt>true</tt> if the iterator has more elements.
     */
    public boolean hasNext();

    /**
     * Returns the next element in the iteration.
     *
     * @return the next element in the iteration.
     * @exception XPathException if the next element could not be found.
     */
    public Object next() throws XPathException;
}
