package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

public class AttributeAxis extends Axis {
    public AttributeAxis() {}

    public AxisIterator iterator(Object contextNode, Navigator navigator)
                                                  throws XPathException {
        return new AttributeAxisIterator(contextNode, navigator);
    }

    /**
     * The principal node type of this axis is
     * {@link Navigator#ATTRIBUTE}.
     **/
    public int getPrincipalNodeType() {
        return Navigator.ATTRIBUTE;
    }

    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "attribute";
    }

    class AttributeAxisIterator implements AxisIterator {
        private Object contextNode;
        private Navigator navigator;
        private int count;
        private int current = 0;

        AttributeAxisIterator(Object contextNode, Navigator navigator)
                                               throws XPathException {
            this.contextNode = contextNode;
            this.navigator = navigator;
            count = navigator.attributeCount(contextNode);
        }

        public boolean hasNext() {
            return current < count;
        }

        public Object next() throws XPathException {
            if (current >= count) throw new XPathException(
                            "No more elements in iterator");
            return navigator.getAttribute(contextNode, current++);
        }
    }
}
