package org.planx.xpath.expr;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

/**
 * Represents a node type test.
 **/
public class NodeTypeTest extends NodeTest {
    public static final int PRINCIPAL = 1;
    public static final int TEXT = 2;
    public static final int NODE = 3;

    private int nodeType;

    public NodeTypeTest(int nodeType) {
        this.nodeType = nodeType;
    }

    public boolean matches(Object node, int principalNodeType,
                   Navigator navigator) throws XPathException {

        int type = navigator.getType(node);
        switch (nodeType) {
        case PRINCIPAL:
            return (type == principalNodeType);
        case TEXT:
            return (type == Navigator.TEXT);
        case NODE:
            return true;
        default:
            throw new RuntimeException("Unsupported type: "+nodeType);
        }
    }

    public String toString() {
        switch (nodeType) {
        case PRINCIPAL:
            return "*";
        case TEXT:
            return "text()";
        case NODE:
            return "node()";
        default:
            return "ILLEGAL";
        }
    }
}
