package org.planx.xpath;

import org.w3c.dom.*;

public class DOMNavigator implements Navigator {
    public DOMNavigator() {}

    public Object getRoot(Object node) throws XPathException {
        return ((Node) node).getOwnerDocument().getDocumentElement();
    }

    public Object getParent(Object node) throws XPathException {
        Node parent = ((Node) node).getParentNode();
        if (parent instanceof Document) return null;
        return parent;
    }

    public Object nextSibling(Object node) throws XPathException {
        return ((Node) node).getNextSibling();
    }

    public Object previousSibling(Object node) throws XPathException {
        return ((Node) node).getPreviousSibling();
    }

    public Object getChild(Object node, int index) throws XPathException {
        return ((Node) node).getChildNodes().item(index);
    }

    public int childCount(Object node) throws XPathException {
        return ((Node) node).getChildNodes().getLength();
    }

    public Object getAttribute(Object node, int index) throws XPathException {
        return ((Node) node).getAttributes().item(index);
    }

    public int attributeCount(Object node) throws XPathException {
        return ((Node) node).getAttributes().getLength();
    }

    // Data

    public String getName(Object node) throws XPathException {
        Node n = (Node) node;
        switch (n.getNodeType()) {
        case Node.ATTRIBUTE_NODE:
        case Node.ELEMENT_NODE:
            return n.getNodeName();
        case Node.TEXT_NODE:
            return null;
        default:
            throw new XPathException("Unsupported object type");
        }
    }

    public String getStringValue(Object node) throws XPathException {
        Node n = (Node) node;
        switch (n.getNodeType()) {
        case Node.ATTRIBUTE_NODE:
            return n.getNodeValue();
        case Node.ELEMENT_NODE:
        case Node.TEXT_NODE:
            StringBuffer sb = new StringBuffer();
            appendStringValue(n, sb);
            return sb.toString();
        default:
            throw new XPathException("Unsupported object type");
        }
    }

    private void appendStringValue(Node node, StringBuffer sb)
                                        throws XPathException {
        switch (node.getNodeType()) {
        case Node.ELEMENT_NODE:
            NodeList children = node.getChildNodes();
            for (int i = 0, size = children.getLength(); i < size; i++) {
                appendStringValue(children.item(i), sb);
            }
            break;
        case Node.TEXT_NODE:
            sb.append(node.getNodeValue());
            break;
        default:
            throw new XPathException("Unsupported object type");
        }
    }

    public int getType(Object node) throws XPathException {
        Node n = (Node) node;
        switch (n.getNodeType()) {
        case Node.ATTRIBUTE_NODE:
            return Navigator.ATTRIBUTE;
        case Node.ELEMENT_NODE:
            return Navigator.ELEMENT;
        case Node.TEXT_NODE:
            return Navigator.TEXT;
        default:
            throw new XPathException("Unsupported object type");
        }
    }
}
