package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.planx.xmlstore.routing.messaging.*;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Space;

/**
 * Finds the <i>K</i> closest nodes to a specified identifier and returns their
 * associated peer information objects.
 *
 * @author Thomas Ambus
 **/
public class ResponsibleOperation extends Operation {
    private Configuration conf;
    private MessageServer server;
    private Space space;
    private Node local;
    private Identifier key;

    public ResponsibleOperation(Configuration conf, MessageServer server, Space space,
                                                           Node local, Identifier key) {
        if (key == null) throw new NullPointerException("Key is null");
        this.conf = conf;
        this.server = server;
        this.space = space;
        this.local = local;
        this.key = key;
    }

    /**
     * Returns a List of InetSocketAddress objects identifying the <i>K</i> closest
     * peers to the key specified in the constructor.
     *
     * @throws RoutingException If the operation timed out
     * @throws IOException      If a network error occurred
     **/
    public synchronized Object execute() throws IOException, RoutingException {
        // Perform lookup for K closest nodes
        Operation op = new NodeLookupOperation(conf, server, space, local, key);
        List nodes = (List) op.execute();

        List info = new ArrayList(nodes.size());
        for (int i=0, max=nodes.size(); i < max; i++) {
            Node node = (Node) nodes.get(i);
            info.add(new InetSocketAddress(node.getInetAddress(), node.getContactPort()));
        }
        return info;
    }
}
