package org.planx.xmlstore.convert;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.*;
import org.xml.sax.*;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 */
public class DOMUtil {
    public static org.w3c.dom.Node removeEmptyTextNodes(org.w3c.dom.Node node) {
        if (node.getNodeType() == org.w3c.dom.Node.ELEMENT_NODE) {
            org.w3c.dom.NodeList children = node.getChildNodes();
            int length = children.getLength();

            for (int i = 0; i < length; i++) {
                org.w3c.dom.Node child = children.item(i);
                if(child == null) continue;
                switch (child.getNodeType()) {
                case org.w3c.dom.Node.ELEMENT_NODE:
                    node.replaceChild(removeEmptyTextNodes(child),child);
                    break;

                case org.w3c.dom.Node.TEXT_NODE:
                    if (child.getNodeValue().trim().length() == 0) {
                        // node lists are live, so remember to update
                        node.removeChild(child);
                        i -= 1;
                    }
                    break;
                }
            }
        } else if (node.getNodeType() == org.w3c.dom.Node.TEXT_NODE) {
            if (node.getNodeValue().trim().length() == 0)
                return null;
        }
        return node;
    }

    public static org.w3c.dom.Document parseSource(InputSource in)
                                 throws XMLException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        } catch (SAXException e) {
            throw new XMLException(e);
        } catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
    }

    public static org.w3c.dom.Document parseFile(String filename)
                                throws XMLException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new File(filename));
        } catch (SAXException e) {
            throw new XMLException(e);
        } catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
    }
}
