package org.planx.util;

import java.util.*;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 */
public class LRUCache<K,V> extends LinkedHashMap<K,V> {
    private int maxEntries;

    public LRUCache() {
        this(50);
    }

    public LRUCache(int maxEntries) {
        /* new LinkedListMap maxsize of MAX_ENTRIES+1,
           load factor 0.75 (default) orders entries after access */
        super(maxEntries+1, .75F, true);
        this.maxEntries = maxEntries;
    }

    // called after a new entry is added
    // removes the oldest entry if cache is full
    protected boolean removeEldestEntry(Map.Entry<K,V> eldest) {
        return size() > maxEntries;
    }
}
