package org.planx.util;

import java.util.*;
import org.planx.xmlstore.*;
import org.planx.xmlstore.io.*;
import org.planx.xmlstore.nodes.*;
import org.planx.util.*;

public class IndexSet<K,V> implements Iterable<V> {
    HashMap<K,Set<V>> map;
    private int size = 0;

    public IndexSet() {
        map = new HashMap<K,Set<V>>();
    }

    public Iterator<V> iterator() {
        return new Iterator<V>() {
            Iterator<Set<V>> it = map.values().iterator();
            Iterator<V> current = null;

            public boolean hasNext() {
                if (current != null && current.hasNext()) return true;
                return it.hasNext();
            }

            public V next() {
                if (current == null || !current.hasNext())
                    current = it.next().iterator();
                return current.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return size;
    }

    public Set<V> get(K key) {
        return map.get(key);
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public boolean contains(K key) {
        return map.containsKey(key);
    }

    public void add(K key, V edge) {
        Set<V> set = map.get(key);
        if (set == null) set = new HashSet<V>(1);
        int before = set.size();
        set.add(edge);
        if (set.size() > before) size++;
        map.put(key,set);
    }

    public void remove(K key, V edge) {
        Set<V> set = map.get(key);
        if (set != null) {
            int before = set.size();
            set.remove(edge);
            int after = set.size();
            if (after < before) size--;
            if (after == 0) map.remove(key);
        }
    }

    public void clear() {
        map.clear();
        size = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (Object o : this) {
            if (!isFirst) sb.append(',');
            sb.append(o.toString());
            isFirst = false;
        }
        sb.append('}');
        return sb.toString();
    }
}
