package org.planx.util;

/**
 * A mutable implementation of <code>Pair</code>.
 *
 * @author Thomas Ambus
 */
public class Association<T,S> implements Pair<T,S> {
    protected T first;
    protected S second;

    public Association(T first, S second) {
        this.first = first;
        this.second = second;
    }

    public T getFirst() {
        return first;
    }

    public void setFirst(T o) {
        first = o;
    }

    public S getSecond() {
        return second;
    }

    public void setSecond(S o) {
        second = o;
    }

    /**
     * Returns <code>true</code> if and only if the specified object is also a
     * <code>Pair</code> and its first and second components are pairwise
     * equal to this object's first and second components using the <code>equals</code>
     * method (or pairwise <code>null</code>).
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof Pair)) return false;

        Pair other = (Pair) o;
        Object oFirst = other.getFirst();
        Object oSecond = other.getSecond();
        return ((first == null && oFirst == null) ||
                (first != null && first.equals(oFirst))) &&
               ((second == null && oSecond == null) ||
                (second != null && second.equals(oSecond)));
    }

    public int hashCode() {
        int h1 = (first == null) ? 0 : first.hashCode();
        int h2 = (second == null) ? 0 : second.hashCode();
        return 31*h1+h2;
    }

    public String toString() {
        String s1 = (first == null) ? "null" : first.toString();
        String s2 = (second == null) ? "null" : second.toString();
        return "("+s1+","+s2+")";
    }
}
