package org.planx.msd.list;

import java.util.Collection;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>List</code>s considered as sets. That is, two lists are considered
 * equivalent if they contain the same elements in any order and any number.
 * <p>
 * This implementation uses a <code>ShortArrayDiscriminator</code> to
 * discriminate the lists after they have been weak sorted and elements
 * replaced by <code>short</code> tokens. This gives the restriction that
 * there must be at most 2^16 different elements (equivalence classes) in
 * the input.
 * <p>
 * <b>Note that this implementation is not synchronized.</b> If multiple
 * threads access an instance of this class concurrently, it must be
 * synchronized externally.
 *
 * @author Thomas Ambus
 */
public class ShortSetDiscriminator<T> extends AbstractDiscriminator<List<T>> {
    private Discriminator<List<T>> bagDisc;

    /**
     * Constructs a new <code>ShortSetDiscriminator</code> where the
     * specified <code>Discriminator</code>
     * is capable of discriminating the elements contained in the sets.
     * The instance will reuse the memory of the specified <code>Memory</code>.
     */
    public ShortSetDiscriminator(Discriminator<T> d, Memory memory) {
        bagDisc = new ShortBagDiscriminator<T>(d, memory, true);
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                        Extractor<U,? extends List<T>,S> e) {
        return bagDisc.discriminate(values, e);
    }
}
