package org.planx.msd.lang;

import java.util.Collection;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> that enables discrimination of recursive
 * datatypes.
 * To do this, first create an instance of <code>RecursionDiscriminator</code>.
 * Then, define the discriminator for the datatype by using this instance as a
 * discriminator symbolizing the point where recursion is desired, i.e.
 * where the whole discriminator expression is to be repeated. Finally,
 * when the discriminator has been defined, use {@link #setRecursion}
 * with the discriminator as argument to complete the
 * <code>RecursionDiscriminator</code>.
 * <p>
 * In practice, for the recursion to be finite the most common case is
 * to use a <code>PolymorphicDiscriminator</code> that chooses between
 * the <code>RecursionDiscriminator</code> and some non-recursive
 * discriminator based on the input.
 *
 * @author Thomas Ambus
 */
public class RecursionDiscriminator<T> extends AbstractDiscriminator<T> {
    private Discriminator<T> d;

    /**
     * Creates a new uninitialized <code>RecursionDiscriminator</code>.
     * The discriminator can be used as a recursion token and must be
     * initialized by {@link #setRecursion} before use.
     */
    public RecursionDiscriminator() {}

    /**
     * Initialize the recursive discriminator. For recursion to actually
     * occur, the argument must contain a (possibly nested) reference to
     * this <code>RecursionDiscriminator</code>.
     */
    public void setRecursion(Discriminator<T> d) {
        this.d = d;
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                              Extractor<U,? extends T,S> e) {
        return d.discriminate(values, e);
    }
}
