package org.planx.msd.graph;

import java.util.List;

/**
 * A Navigator is a bridge between MSD and a document model.
 **/
public interface Navigator<N> {
    /**
     * Returns the child of the specified node with the specified child
     * index.
     **/
    public N getChild(N node, int index);

    /**
     * Replaces an existing reference to a child node.
     */
    public void setChild(N node, int index, N child);

    /**
     * Returns the number of children of the specified node.
     **/
    public int childCount(N node);

    /**
     * Returns the visit token of the specified node.
     * This is used to ensure that subtrees are not visited multiple
     * times during dagification.
     */
    public Object getVisitToken(N node);

    /**
     * Sets the visit token of the specified node.
     */
    public void setVisitToken(N node, Object token);

    /**
     * Returns the height of the specified node.
     */
    public int getHeight(N node);

    /**
     * Sets the height of the specified node.
     */
    public void setHeight(N node, int height);

    /**
     * Returns <code>true</code> if the specified node is outside the bounds
     * for the discrimination. The node will not be visited.
     */
    public boolean isOutside(N node);

    /**
     * Choose the canonical node from among equivalent nodes. This method
     * will only be called for equivalence classes containing more than one
     * element.
     */
    public N chooseCanonical(List<Compactor<N>.Edge> eqCls);
}
