/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.function;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.function.Function;
import org.planx.xpath.function.FunctionException;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XObject;
import org.planx.xpath.object.XSimple;
import org.planx.xpath.object.XString;

public class StringFunction
implements Function {
    @Override
    public XObject evaluate(XObject[] args, Context ctxt, Environment env, Navigator nav) throws FunctionException {
        if (args.length == 0) {
            return this.evaluate(ctxt.getNode(), nav);
        }
        if (args.length == 1) {
            return this.evaluate(args[0], nav);
        }
        throw new FunctionException("Illegal number of arguments");
    }

    public XObject evaluate(Object arg, Navigator navigator) throws FunctionException {
        try {
            if (arg instanceof XString) {
                return (XString)arg;
            }
            if (arg instanceof XNodeSet) {
                XNodeSet set = (XNodeSet)arg;
                if (set.size() == 0) {
                    return new XString("");
                }
                String value = navigator.getStringValue(set.get(0));
                return new XString(value);
            }
            if (arg instanceof XSimple) {
                return new XString(((XSimple)arg).stringValue());
            }
            return new XString(navigator.getStringValue(arg));
        }
        catch (XPathException e) {
            throw new FunctionException(e);
        }
    }
}

