/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.operator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.operator.EqualityOperator;
import org.planx.xpath.object.XNodeSet;

public class EqualOperator
extends EqualityOperator {
    public EqualOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    @Override
    protected boolean compare(XNodeSet s1, XNodeSet s2, Navigator navigator) throws XPathException {
        int i;
        if (s2.size() < s1.size()) {
            XNodeSet s3 = s1;
            s1 = s2;
            s2 = s3;
        }
        HashMap hashes = new HashMap();
        int size1 = s1.size();
        for (i = 0; i < size1; ++i) {
            Object o1 = s1.get(i);
            String str1 = navigator.getStringValue(o1);
            Integer hash = new Integer(str1.hashCode());
            ArrayList<Object> objs = (ArrayList<Object>)hashes.get(hash);
            if (objs == null) {
                objs = new ArrayList<Object>(1);
                objs.add(o1);
                hashes.put(hash, objs);
                continue;
            }
            if (this.equalsAny(str1, objs, navigator)) continue;
            objs.add(o1);
        }
        int size2 = s2.size();
        for (i = 0; i < size2; ++i) {
            String str2 = navigator.getStringValue(s2.get(i));
            Integer hash = new Integer(str2.hashCode());
            List objs = (List)hashes.get(hash);
            if (objs == null || !this.equalsAny(str2, objs, navigator)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsAny(String s, List hs, Navigator nav) throws XPathException {
        int size = hs.size();
        for (int i = 0; i < size; ++i) {
            String r = nav.getStringValue(hs.get(i));
            if (!s.equals(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean compare(boolean v1, boolean v2) {
        return v1 == v2;
    }

    @Override
    protected boolean compare(double v1, double v2) {
        return v1 == v2;
    }

    @Override
    protected boolean compare(String v1, String v2) {
        return v2.equals(v1);
    }

    @Override
    protected String operatorName() {
        return "=";
    }
}

