/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr;

import java.util.ArrayList;
import java.util.List;
import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XNumber;
import org.planx.xpath.object.XObject;

public class PredicateList {
    private List predicates = new ArrayList();

    public void addPredicate(Expression expr) {
        this.predicates.add(0, expr);
    }

    public XNodeSet evaluate(XNodeSet ctxtSet, Environment env, Navigator nav) throws XPathException {
        if (this.predicates.isEmpty()) {
            return ctxtSet;
        }
        int ctxtSize = ctxtSet.size();
        boolean[] filter = new boolean[ctxtSize];
        for (int i = 0; i < ctxtSize; ++i) {
            filter[i] = true;
        }
        Context ctxt = new Context();
        ctxt.setSize(ctxtSize);
        int max = this.predicates.size();
        for (int i = 0; i < max; ++i) {
            Expression expr = (Expression)this.predicates.get(i);
            for (int j = 0; j < ctxtSize; ++j) {
                ctxt.setNode(ctxtSet.get(j));
                ctxt.setPosition(j + 1);
                XObject value = expr.evaluate(ctxt, env, nav);
                if (value instanceof XNumber) {
                    XNumber num = (XNumber)value;
                    filter[j] = filter[j] && num.intValue() == j + 1;
                    continue;
                }
                filter[j] = filter[j] && value.booleanValue();
            }
        }
        XNodeSet matching = new XNodeSet();
        for (int i = 0; i < ctxtSize; ++i) {
            if (!filter[i]) continue;
            matching.add(ctxtSet.get(i));
        }
        return matching;
    }

    public String toString() {
        return this.predicates.isEmpty() ? "" : this.predicates.toString();
    }
}

