/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr;

import java.util.List;
import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.function.Function;
import org.planx.xpath.object.XObject;

public class FunctionCall
extends Expression {
    private final String funcName;
    private final List args;

    public FunctionCall(String funcName) {
        this(funcName, null);
    }

    public FunctionCall(String funcName, List args) {
        this.funcName = funcName;
        this.args = args;
    }

    @Override
    public XObject evaluate(Context ctxt, Environment env, Navigator nav) throws XPathException {
        int argsize = this.args == null ? 0 : this.args.size();
        XObject[] argvalues = new XObject[argsize];
        for (int i = 0; i < argsize; ++i) {
            Expression expr = (Expression)this.args.get(i);
            argvalues[i] = expr.evaluate(ctxt, env, nav);
        }
        Function function = env.getFunction(this.funcName);
        return function.evaluate(argvalues, ctxt, env, nav);
    }

    public String toString() {
        if (this.args == null || this.args.isEmpty()) {
            return this.funcName + "()";
        }
        return this.funcName + "(" + this.args + ")";
    }
}

