/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.XMLStore;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.nodes.InlineNodeStreamer;
import org.planx.xmlstore.stores.NetworkProtocolException;

class NetworkRequestHandler
implements Runnable {
    private static Streamer<Node> inlineNodeStreamer = new InlineNodeStreamer();
    private Streamer<Reference> vrefStreamer;
    private Socket socket;
    private XMLStore xmlstore;
    private DataInputStream in;
    private DataOutputStream out;
    private boolean isRunning = true;

    public NetworkRequestHandler(XMLStore xmlstore, Socket socket) throws IOException {
        this.xmlstore = xmlstore;
        this.socket = socket;
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        socket.setSoTimeout(5000);
        this.vrefStreamer = Streamers.getPolymorphicStreamer(Reference.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte b = this.in.readByte();
            if (b != 1) {
                throw new NetworkProtocolException("Expected REQUEST_VERSION");
            }
            this.out.writeByte(2);
            this.out.flush();
            block51: while (this.isRunning) {
                byte command = this.in.readByte();
                switch (command) {
                    case 2: {
                        this.handleLoad();
                        continue block51;
                    }
                    case 3: {
                        this.handleSave();
                        continue block51;
                    }
                }
                throw new NetworkProtocolException("Unknown client command " + command);
            }
        }
        catch (InterruptedIOException e) {
        }
        catch (EOFException e) {
        }
        catch (SocketException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException e) {}
            try {
                this.out.close();
            }
            catch (IOException e) {}
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void handleLoad() throws IOException {
        Reference vref = this.vrefStreamer.fromStream(this.in);
        try {
            Node node = this.xmlstore.load(vref);
            this.out.writeByte(1);
            inlineNodeStreamer.toStream(this.out, node);
        }
        catch (IOException e) {
            this.out.writeByte(2);
            e.printStackTrace();
        }
        catch (UnknownReferenceException e) {
            this.out.writeByte(3);
            e.printStackTrace();
        }
        this.out.flush();
    }

    private void handleSave() throws IOException {
        Node node = inlineNodeStreamer.fromStream(this.in);
        try {
            Reference vref = this.xmlstore.save(node);
            this.out.writeByte(1);
            this.vrefStreamer.toStream(this.out, vref);
        }
        catch (IOException e) {
            this.out.writeByte(2);
            e.printStackTrace();
        }
        this.out.flush();
    }
}

