/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.stores;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.io.Streamer;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.nodes.InlineNodeStreamer;
import org.planx.xmlstore.stores.AbstractXMLStore;
import org.planx.xmlstore.stores.NetworkProtocolException;

public class NetworkProxy
extends AbstractXMLStore {
    private static Streamer<Node> inlineNodeStreamer = new InlineNodeStreamer();
    private Streamer<Reference> vrefStreamer;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private InetAddress addr;
    private int port;

    public NetworkProxy(String host, int port) throws IOException, UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    public NetworkProxy(InetSocketAddress sockaddr) throws IOException {
        this(sockaddr.getAddress(), sockaddr.getPort());
    }

    public NetworkProxy(InetAddress addr, int port) throws IOException {
        this.addr = addr;
        this.port = port;
        this.socket = new Socket(addr, port);
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.vrefStreamer = Streamers.getPolymorphicStreamer(Reference.class);
        this.out.writeByte(1);
        this.out.flush();
        byte version = this.in.readByte();
        if (version != 2) {
            throw new NetworkProtocolException("Unknown protocol version");
        }
    }

    @Override
    protected Node resolvedLoad(Reference vref) throws IOException, UnknownReferenceException {
        this.checkClosed();
        this.out.writeByte(2);
        this.vrefStreamer.toStream(this.out, vref);
        this.out.flush();
        byte status = this.in.readByte();
        this.checkErrors(status);
        Node node = inlineNodeStreamer.fromStream(this.in);
        return node;
    }

    @Override
    public Reference save(Node node) throws IOException {
        try {
            this.checkClosed();
            this.out.writeByte(3);
            inlineNodeStreamer.toStream(this.out, node);
            this.out.flush();
            byte status = this.in.readByte();
            this.checkErrors(status);
            Reference vref = this.vrefStreamer.fromStream(this.in);
            return vref;
        }
        catch (UnknownReferenceException e) {
            throw new NetworkProtocolException("Save should not cause UnknownReferenceException");
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.out.close();
        this.out = null;
        this.socket.close();
        this.socket = null;
    }

    @Override
    public String toString() {
        return this.addr.toString() + ":" + this.port;
    }

    @Override
    protected void checkClosed() {
        if (this.socket == null) {
            throw new IllegalStateException("XMLStore is closed");
        }
    }

    private void checkErrors(byte status) throws IOException, UnknownReferenceException {
        switch (status) {
            case 1: {
                return;
            }
            case 2: {
                throw new IOException("Remote exception");
            }
            case 3: {
                throw new UnknownReferenceException("Remote exception");
            }
        }
        throw new NetworkProtocolException("Unknown response code " + status);
    }
}

