/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.TimestampedValue;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.NodeLookupOperation;
import org.planx.xmlstore.routing.operation.Operation;
import org.planx.xmlstore.routing.operation.StoreMessage;

public class StoreOperation
extends Operation {
    private Configuration conf;
    private MessageServer server;
    private Space space;
    private Map localMap;
    private Node local;
    private Identifier key;
    private TimestampedValue value;

    public StoreOperation(Configuration conf, MessageServer server, Space space, Map localMap, Node local, Identifier key, TimestampedValue value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        this.conf = conf;
        this.server = server;
        this.space = space;
        this.localMap = localMap;
        this.local = local;
        this.key = key;
        this.value = value;
    }

    @Override
    public synchronized Object execute() throws IOException, RoutingException {
        NodeLookupOperation op = new NodeLookupOperation(this.conf, this.server, this.space, this.local, this.key);
        List nodes = (List)((Operation)op).execute();
        StoreMessage message = new StoreMessage(this.local, this.key, this.value, false);
        int max = nodes.size();
        for (int i = 0; i < max; ++i) {
            Node node = (Node)nodes.get(i);
            if (node.equals(this.local)) {
                this.localMap.put(this.key, this.value);
                continue;
            }
            this.server.send(message, node.getInetAddress(), node.getPort(), null);
        }
        return null;
    }
}

