/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.HashCalculator;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.RoutingException;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.operation.HashMessage;
import org.planx.xmlstore.routing.operation.Operation;
import org.planx.xmlstore.routing.operation.RefreshOperation;

public class RestoreOperation
extends Operation {
    private Configuration conf;
    private MessageServer server;
    private Space space;
    private Node local;
    private Map localMap;
    private HashCalculator hasher;

    public RestoreOperation(Configuration conf, MessageServer server, Space space, Node local, Map localMap) {
        this.conf = conf;
        this.server = server;
        this.space = space;
        this.local = local;
        this.localMap = localMap;
        this.hasher = new HashCalculator(local, space, localMap);
    }

    @Override
    public synchronized Object execute() throws IOException, RoutingException {
        RefreshOperation refresh = new RefreshOperation(this.conf, this.server, this.space, this.local);
        ((Operation)refresh).execute();
        HashSet nodes = new HashSet();
        Iterator<Object> it = this.localMap.keySet().iterator();
        while (it.hasNext()) {
            Identifier key = (Identifier)it.next();
            List closest = this.space.getClosestNodes(key);
            if (!closest.contains(this.local)) {
                it.remove();
                continue;
            }
            nodes.addAll(closest);
        }
        nodes.remove(this.local);
        long now = System.currentTimeMillis();
        for (Node node : nodes) {
            List hashes = this.hasher.logarithmicHashes(node, now);
            if (hashes.size() <= 0) continue;
            HashMessage mess = new HashMessage(this.local, now, hashes);
            this.server.send(mess, node.getInetAddress(), node.getPort(), null);
        }
        return null;
    }
}

