/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing.operation;

import java.io.IOException;
import java.util.Map;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.TimestampedValue;
import org.planx.xmlstore.routing.messaging.Message;
import org.planx.xmlstore.routing.messaging.MessageServer;
import org.planx.xmlstore.routing.messaging.UnknownMessageException;
import org.planx.xmlstore.routing.operation.DataLookupMessage;
import org.planx.xmlstore.routing.operation.DataMessage;
import org.planx.xmlstore.routing.operation.NodeLookupReceiver;
import org.planx.xmlstore.routing.operation.OriginReceiver;

public class DataLookupReceiver
extends OriginReceiver {
    protected Map localMap;

    public DataLookupReceiver(MessageServer server, Node local, Space space, Map localMap) {
        super(server, local, space);
        this.localMap = localMap;
    }

    @Override
    public void receive(Message incoming, int comm) throws IOException, UnknownMessageException {
        DataLookupMessage mess = (DataLookupMessage)incoming;
        Identifier key = mess.getLookupId();
        if (this.localMap.containsKey(key)) {
            super.receive(incoming, comm);
            Node origin = mess.getOrigin();
            DataMessage reply = new DataMessage(this.local, key, (TimestampedValue)this.localMap.get(key));
            this.server.reply(comm, reply, origin.getInetAddress(), origin.getPort());
        } else {
            NodeLookupReceiver recv = new NodeLookupReceiver(this.server, this.local, this.space);
            recv.receive(incoming, comm);
        }
    }
}

